local assets=
{
	Asset("ANIM", "anim/lightning_projectile.zip"),

}

local function OnHit(inst, owner, target)
	owner.SoundEmitter:PlaySound("dontstarve/common/staff_blink")
	owner.components.playercontroller:ShakeCamera(inst, "FULL", 0.5, 0.02, .35, 40)
    inst:Remove()
end

local function bell()
    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    
    anim:SetBank("projectile")
    anim:SetBuild("lightning_projectile")
    
    inst:AddTag("projectile")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(50)
    inst.components.projectile:SetLaunchOffset(Vector3(2, .5, 0))
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst.AnimState:PlayAnimation("lightning_spin_loop", true)
    inst.components.projectile:SetOnHitFn(OnHit)
    --colour projectile
    --inst.AnimState:SetMultColour(0, 0, 0, 1)
    return inst
end

return Prefab("common/inventory/lightning_projectile", bell, assets) 
